// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

// The ShaderToy shaders often use textures as inputs named iChannel0. With VGHD
// this may access a Sprite, ClipSprite or ClipNameSprite image depending on how
// the .scn file declares them.
//
// Note, the name used here does not seem to make any difference, so I have used
// iChannel0 which is what is used by ShaderToy but you can use any name as long
// as it matches the use in the main body of the shader. TheEmu.

uniform sampler2D iChannel0;

// With VGHD the range of the P argument's components of the texture functions is
// 0.0 to 1.0 whereas with ShaderToy it seems that the upper limits are given  by
// the number of pixels in each direction, typically 512 or 64.  We therefore use
// the following functions instead.

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}

// Rather than edit the body of the original shader we use use a define  here  to
// redirect texture calls to the above functions.

#define texture2D texture2D_Fract

/////////////////////////////////////////////////////////////////////////////////

vec2 cmult(vec2 a, vec2 b)
{
   vec2 p;
   p[0]=a[0]*b[0]-a[1]*b[1];
   p[1]=a[0]*b[1]+a[1]*b[0];
   return p;
}

float shade=.13;
float zoom=5.;
float X=-.61;
float Y=.4234;
float bailout=5.;
float depthCull=.1;
float time=iGlobalTime;
vec2  offset=vec2(.5,.3);
const int iterations=32;

void main ( void )
{
   vec2 uv = gl_FragCoord.xy / iResolution.x;
   zoom +=-1.5+sin(iGlobalTime*.1)*1.6;
   zoom +=-1.5+sin(iGlobalTime*.03)*.15;

   offset.x +=sin(iGlobalTime*.4)*.05;
   offset.y +=cos(iGlobalTime*.6)*.05;
   shade +=.1+cos(iGlobalTime*40.)*.02;
   vec2 position = uv-offset;//gl_TexCoord[0].xy - offset;
   position = position * zoom;
   vec2 mouse=vec2(X,Y);
   mouse.x +=sin(iGlobalTime*.4)*.01;
   mouse.y +=cos(iGlobalTime*.3)*.01;

   vec2 c, c0, d;
   float v;

   c = vec2(position);
   c0 = mouse;

   vec2 f = position.xy;
   for(int i=0; i<iterations; i++) {
      d = cmult(c, c);
      c = d + c0;
      v = ((c.x*c.x)) + (c.y*c.y) / sin(length(c.x )*4.);
      if (v > bailout) break;
   }
   //vec4 tex=texture2D(texture, c);
   float l=sin(( c.y*2.)*.23);

   //l +=sin(c.y *1.2)*.5;
   //l +=sin(c.y *.2)*.1;
   c.x+=sin(c.y*2.);
   c.y+=sin(c.x*20.)*.1;
   c.x+=sin(c.y*3.);
   c.y+=sin(c.x*5.);

   float rand = mod(fract(sin(dot(2.5*uv,vec2(12.9898,100.233+time)))*43758.5453),.5);

   vec4 color;
   if(v>depthCull*20.){
      color = vec4(rand + vec3(sin((c.y*4.)*.4+sin(c.x*10.)*3.)+.2,
                            length(-1.1-c*.1),
                            sin(c.y))*pow(v,-shade-.23),1.)*vec4(vec3(.4),1.);
   }

   else{
   v +=sin(c.x*20.)*.01;
   v +=sin(c.y*120.)*.02;
   v +=sin(c.y*20.)*.1;
   v +=sin(c.x*4.)*.2;
   v +=sin(c.x*7.)*.2;
   v = clamp(v,0.,1.);
   color = vec4((rand*.75)+vec3(pow(v+.3,-.75)),1.)*vec4(.3,.5,1.,1.);
   }

   gl_FragColor = color;

}